% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WR79.R
\docType{data}
\name{WR79}
\alias{WR79}
\title{Ages and lengths for a hypothetical sample from Westerheim and Ricker (1979).}
\format{
A data frame of 2369 observations on the following 3 variables:
 \describe{
   \item{ID}{Unique fish identifiers}
   \item{len}{Length of an individual fish}
   \item{age}{Age of an individual fish}
 }
}
\source{
Simulated from Table 2A in Westerheim, S.J. and W.E. Ricker. 1979. Bias in using age-length key to estimate age-frequency distributions. Journal of the Fisheries Research Board of Canada. 35:184-189.
}
\description{
Ages and lengths for a hypothetical sample in Westerheim and Ricker (1979).
}
\details{
Age-length data in 5-cm increments taken exactly from Table 2A of the source which was a sample from a hypothetical population in which year-class strength varied in the ratio 2:1 and the rate of increase in length decreased with age. Actual lengths in each 5-cm interval were simulated with a uniform distribution. The aged fish in this file were randomly selected and an assessed age was assigned according to the information in Table 2A.
}
\section{Topic(s)}{

 \itemize{
   \item Age-Length Key
 }
}

\examples{
str(WR79)
head(WR79)

## Extract the aged sample
WR79.aged <- subset(WR79,!is.na(age))
str(WR79.aged)

## Extract the length sample
WR79.length <- subset(WR79,is.na(age))
str(WR79.length)

}
\concept{Age-Length Key}
\keyword{datasets}
