% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fromSource.R
\name{composeFromSource}
\alias{composeFromSource}
\title{Compose a Acumos microservice from its source file}
\usage{
composeFromSource(
  file = "acumos.R",
  name = "R Component",
  outputfile = "component.zip",
  addSource = T
)
}
\arguments{
\item{file}{string, name of component source file (an R script)}

\item{name}{string, name of the component}

\item{outputfile}{string, filename for the resulting component file}

\item{addSource}{boolean, to add source file to the (ZIP) bundle or not}
}
\value{
Structure describing the component (parsed content of the JSON description).
}
\description{
\code{composeFromSource} generates everything necessary to create a Acumos microservice directly 
from a specifically written R file, representing the component source.
}
\note{
A regular component source file is an R script in which at least one of the three following 
functions are defined: \code{acumos_predict}, \code{acumos_transform} or \code{acumos_fit}. 
They respectively correspond to the functions \code{predict}, \code{transform} and \code{fit} 
of \code{\link{compose}}. In that script, if the functions \code{acumos_generate}, \code{acumos_service} 
or \code{acumos_initialize} are defined, they will also correspond to the other function 
type arguments of \code{\link{compose}}, namely \code{generate}, \code{service} and \code{initialize}.

All the R objects defined in that script are included as auxiliary objects that are to be passed to 
the global workspace of the component. They will fill the \code{aux} argument of \code{\link{compose}}.
}
\examples{
# see an example source file in:
print(system.file("examples","example_0/", package = "acumos"))
# compose from acumos.R
example_source<-system.file("examples","example_0","acumos.R", package = "acumos")
composeFromSource(
  file=example_source,
  outputfile = "acumos_bundle_example_0.zip"
)

}
\seealso{
\code{\link{compose}}
}
\author{
Alassane Samba
}
