% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.multimixParamList.R
\name{print.multimixParamList}
\alias{print.multimixParamList}
\title{S3 printing method for for multimix parameter results}
\usage{
\method{print}{multimixParamList}(
  x,
  type = c("means", "vars"),
  byLevel = FALSE,
  digits = c(4, 2, 3, 16),
  pedantic = FALSE,
  raw = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of class \code{multimixParamResults} -- see 
\code{\link{initParamList}} for more information.}

\item{type}{the statistic you want displayed. If \code{means} then the cluster
means will be displayed for each univariate continuous variable, the cluster proportions
for each level of a categorical variable, and the mean vector for each cluster and each
multivariate normal variable.}

\item{byLevel}{if \code{TRUE} then location model summary stats will be printed by the 
level of the factor in the location model. Otheriwse (default), they will be printed cluster
by cluster.}

\item{digits}{a vector of length 4. The first value determines how many decimal places to 
round categorical proportions to. The second value determines how many significant digits to 
display means to, and the third how many siginificant digits to display variances to. By default
proportions are rounded to 4 decimal places, means 2 significant digits, and variances 3 significant 
digits. The fourth value is only used if \code{pedantic == TRUE}, and is set to 16 significant figures by
default.}

\item{pedantic}{if \code{TRUE} then the results are printed to high precision for checking purposes.
This means \code{digits[4]} which is 16 decimal places by default.}

\item{raw}{if \code{TRUE} then switches off all of the customised printing and uses the default
print methods for \code{list}s etc.}

\item{...}{additional arguments passed to \code{print}.}
}
\value{
No return value, called for side effects.
}
\description{
S3 printing method for for multimix parameter results
}
\author{
James Curran
}
