
#' Retrieve comments for a notebook and prepare for solr
#'
#' @param notebook_info A list generated by \code{build_notebook_info} with information from
#' the notebook that needs to be added to every solr document
#'
#' @return A list with solr ready comment documents
#'
build_comments <- function(notebook_info) {

  comments_json <- rcloud.support::rcloud.get.comments(notebook_info$notebook_id)

  comments <- rjson::fromJSON(comments_json)

  if(length(comments) <= 0) return(NULL)

  comment_files <- lapply(comments, comment_to_file, notebook_info)

  names(comment_files) <- NULL

  comment_files
}

# Process a single comment
comment_to_file <- function(comment, notebook_info) {

  # Create unique IDs by appending to the notebook ID
  id <- paste0(notebook_info$notebook_id, "comment", comment$id)
  filename <- paste0("comment", comment$id)

  file <- c(list(id = id,
                 doc_type = "comment",
                 filename = filename,
                 content = comment$body),
            notebook_info)

  # Override some notebook settings
  if(exists("updated_at", comment)) file$updated_at <- comment$updated_at
  if(exists("user", comment)) file$user <- comment$updated_at

  file
}
