% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request.R
\name{.solr.post}
\alias{.solr.post}
\title{Post Request to Solr}
\usage{
.solr.post(data, solr.url = rcloud.support:::getConf("solr.url"),
  solr.auth.user = rcloud.support:::getConf("solr.auth.user"),
  solr.auth.pwd = rcloud.support:::getConf("solr.auth.pwd"), isXML = FALSE,
  type = rcloud.support:::getConf("solr.post.method"), detach = TRUE)
}
\arguments{
\item{data}{The body of the request.}

\item{solr.url}{Usually from \code{solr.url} config. In testing can be
\code{http://solr:8983/solr/rcloudnotebooks}}

\item{solr.auth.user}{Usually from \code{solr.url} config. \code{NULL}
in testing}

\item{solr.auth.pwd}{Usually from \code{solr.url} config. \code{NULL} in
testing}

\item{isXML}{Logical. If TRUE the data argument directly becomes the body
and \code{content_type}  is set to "text/xml"}

\item{type}{One of \code{c("async", "sync", "curl")} usually drawn from
config file.}

\item{detach}{Logical. For mcparallel. Should updates be detached and
forgotten about or not?}
}
\value{
The result of the httr::POST (sync). This needs to be unwrapped with
  a \code{parallel::mccollect} with async, and curl just returns \code{NULL}.
}
\description{
Post Request to Solr
}
