## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  echo = FALSE, 
  warning = FALSE,
  message = FALSE
)

## ----get, eval = FALSE, echo=TRUE---------------------------------------------
#  get_submissions()

## ----wfgraph, out.width="100%", fig.width=6, fig.height=6, fig.align='center', fig.align='center'----
library(DiagrammeR)
eic_df <- create_node_df(n=6,  
    label=c("check for new submissions or revisions get_submissions()", # 1
            "is this?", # a new submission?", # 2
            "examine article: should \n the paper progress \n to review?", # 3
            "assign to an EE or to self", # 4
            "acknowledge paper, Cc handling EE \n acknowledge_submission() \n acknowledge_revision()", # 5
            "acknowledge revision received, \n Cc handling EE"), # 6
   shape = c("rectangle", "ellipse", "rectangle", 
             "rectangle", "rectangle", "rectangle"),
   width = c(4, 1, 2, 3, 3, 3),
   fillcolor = c("grey90", "orange", "salmon",  
                 "grey90", "grey90", "turquoise"),
   fontcolor = "black",
   type = c("a", "a", "a", "a", "a", "a"))

eic_edge_df <- create_edge_df(
  from = c(1,2,3,4,2), 
  to = c(2,3,4,5,6), 
  rel = "a",
  label = c(".", "new submission", ".", ".","revision"))

eic <- create_graph(eic_df, 
                       eic_edge_df, 
                       directed = TRUE, attr_theme = "tb")
render_graph(eic, width=400, height=400)

