## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  echo = FALSE, 
  warning = FALSE,
  message = FALSE
)

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  remotes::install_github("rjournal/rj")

## ----wfgraph, fig.width=8, fig.height=12, fig.align='center'------------------
library(DiagrammeR)
editor_df <- create_node_df(n=11,  
    label=c("is this a new submission?", # 1
            "examine article: should the paper progress to review?", # 2
            "is there a suitable AE?", # 3
            "update status to be `with AE`, update_status(), copy folder to AEs repo", # 4
            "message/email AE", # 5
            "has AE returned reviews and decision?", # 6
            "add_review() to correspondence folder, send decision to author, \n with reviews if appropriate, update_status(), \n notify and thank AE about decision, if appropriate", # 7
            "is the revision adequate?", # 8
            "should it go back to AE?", # 9
            "reject(), contact authors", # 10
            "act as AE, find reviewers, update status, follow AE flow chart"), # 11
   shape = c("ellipse", "ellipse", "ellipse", 
             "rectangle", "rectangle", 
             "ellipse", "rectangle", "ellipse", 
             "ellipse", "rectangle", "rectangle"),
   width = c(3, 5, 3, 5, 2, 3, 4, 3, 3, 3, 4),
   fillcolor = c("orange", "orange", "orange", 
                 "grey90", "grey90",
                 "orange", "salmon", "orange", 
                 "orange", "salmon", "turquoise"),
   fontcolor = "black")

editor_edge_df <- create_edge_df(
  from = c(1,2,3,4,5,6,1,8, 8,9,9, 2, 3, 6), 
  to =   c(2,3,4,5,6,7,8,9,10,7,4,10, 11, 5), 
  label = c("Y", "Y", "Y", ".", ".", "Y",
            "N","Y","N", "N", "Y", "N", "N", "N"),
  color = c("dodgerblue2", "dodgerblue2", "dodgerblue2", 
            "grey50", "grey50", "dodgerblue2",
            "red", "dodgerblue2", "red", "red", 
            "dodgerblue2", "red", "red", "red"))

editor <- create_graph(editor_df, 
                       editor_edge_df, 
                       directed = TRUE, attr_theme = "tb")
render_graph(editor)

