% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ae.R
\name{AEs}
\alias{AEs}
\alias{detect_AE}
\alias{AE}
\alias{is_AE}
\title{Associate editor (AE) functions}
\usage{
AEs()

detect_AE(path = ".", require = FALSE)

AE(path = ".")

is_AE(path = ".")
}
\arguments{
\item{path}{string, path to the git repository to use
for detection.}

\item{require}{logical, if \code{TRUE} then failing to detect
the AE is considered an error}
}
\value{
\itemize{
  \item{\code{AEs()}: a data frame with all associate editors}
  \item{\code{detect_AE()}:  \code{NULL} if not found or the
       row from \code{AEs()} corresponding to the AE}
  \item{	\code{AE}: \code{NULL} if not an AE or a row from \code{AEs()}}
  \item{\code{is_AE}: \code{TRUE} if the user if an AE or
  the repository is an AE repository, \code{FALSE} otherwise}
}
}
\description{
Functions to determine if the user is an AE and retrieve relevant AE information
}
\details{
\itemize{
 \item{\code{AEs()}:  read the associate-editors.csv in the rj package as a data frame}
 \item{\code{detect_AE()}: determine AE from the remote of the repository in
 \code{path} or from the git config e-mail.this only work for AE and will fail for editors}
 \item{\code{AE()}: returns the corresponding row from \code{AEs()} if called
by an associate editor or in an AE repository, otherwise
\code{NULL}. It relies on either \code{RJ_EDITOR} environment
variable to contain the name of the editor or detection from the
git repository pointed to by \code{path} (see
\code{\link{detect_AE}}).}
 \item{\code{is_AE()}: determine if the user is an AE or the repository is an AE repository}
}
}
