% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reviewers.R
\name{add_review}
\alias{add_review}
\title{Add the review file received from the reviewer}
\usage{
add_review(
  article,
  reviewer_id,
  review,
  recommend = NULL,
  date = Sys.Date(),
  AE = is_AE()
)
}
\arguments{
\item{article}{Article id, like \code{"2014-01"}}

\item{reviewer_id}{Numeric, the index of the intended reviewer in the Reviewer field.
1 for the first reviewer, 2 for the second}

\item{review}{Path to the review file, e.g. pdf, txt, or docx format. If not specified it is assumed that you added the new file into the correspondence directory and the last file for that reviewer will be used. If you specify \code{<i>-review-<j>.} filename (no path) and it already exists in the correspondence directory, it will be used.}

\item{recommend}{Reviewer's recommendation, one of: Accept, Minor, Major, Reject.
If not specified, an attempt is made to auto-detect it from the file by
looking at the first occurrence of those keywords. If auto-detect fails, use "Received".}

\item{date}{Date of the comment, defaults to today's date}

\item{AE}{Logical, if \code{TRUE} then \code{"AE: "} prefix is added to the recommendation.}
}
\description{
This function adds the review file received from the reviewer to
the correspondence folder of the article.
}
\examples{
\dontrun{
# add review file from the first reviewer and recommend accepting it
add_review("2020-114", reviewer_id = 1, review = file.choose(), recommend = "Accept")
}
}
