## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  echo = FALSE,
  warning = FALSE,
  message = FALSE
)

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  remotes::install_github("rjournal/rj")

## -----------------------------------------------------------------------------
library(DiagrammeR)
AE_df <- create_node_df(n=10,
   type=c("decision", #1
          "action", #2
          "action", #3
          "action", #4
          "action", #5
          "decision", #6
          "decision", #7
          "action", #8
          "action", #9
          "action"), #10
   label=c("Send for review?", #1
           "Select reviewer (ideally two), rj::match_keywords() or use your own experts", #2
           "Update reviewer in DESCRIPTION, rj::add_reviewer() \n This also generates the email template saved in the correspondence folder", #3
           "Send email to reviewers, which includes motivating letter, pdf and R files \n rj::update_status() to out for review", #4
           "Check all file changes into GitHub, \n including correspondence folder", #5
           "Reviewer agreed (1 week)? \n Use agree_reviewer() or\n decline_reviewer()", #6
           "Reviews received", #7
           "Save reviews into correspondence folder, rj::add_review()", #8
           "Make recommendation (AE: major revision, AE: minor revision, AE: accept or AE: reject),\n update DESCRIPTION using rj::update_status(), notify editor, check all into GitHub", #9
           "Send reminder email"), #10
   shape = c("rectangle",
             "rectangle",
             "rectangle",
             "rectangle",
             "rectangle",
             "rectangle",
             "rectangle",
             "rectangle",
             "rectangle",
             "rectangle",
             "rectangle"),
   width = c(3, 5, 6, 6, 3, 4, 3, 4, 6, 2),
   fillcolor = c("orange", "grey90",
                 "grey90", "grey90", "grey90",
                 "orange", "orange", "grey90",
                 "aquamarine2", "grey90"),
   fontcolor = "black")

AE_edge_df <- create_edge_df(from = c(1:8,6,7,10,1),
                             to = c(2:9,2,10,7,9),
                             label = c("Y", rep(".", 4), "Y",
                                       "Y", ".", "N", "N","done","N"),
                             color = c("dodgerblue2",
                                       "grey50", "grey50",
                                       "grey50", "grey50",
                                       "dodgerblue2",
                                       "dodgerblue2",
                                       "grey50",
                                       "red", "red",
                                       "grey50", "red"
                                       ))

AE <- create_graph(AE_df, AE_edge_df,
                   directed = TRUE, attr_theme = "tb")
render_graph(AE)

