% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ae_workload.R
\name{ae_workload}
\alias{ae_workload}
\alias{get_AE}
\title{Check the number of articles an AE is currently working on}
\usage{
ae_workload(articles = NULL, day_back = 365, active_only = FALSE)

get_AE(x)
}
\arguments{
\item{articles}{a tibble summary of articles in the accepted and submissions
folder. Output of \code{tabulate_articles()}}

\item{day_back}{numeric; positive number of day to go back for calculating AE
workload. Retains any article where any status entry for an article is
newer than `day_back` days ago.}

\item{active_only}{Toggle to show only active AEs (filtered by end year and comment field).}

\item{x}{a single article, i.e. as.article("Submissions/2020-114")}
}
\description{
This will examine the DESCRIPTION files for articles in
the Submissions folder, check articles that have status
"with AE".
}
\examples{
\dontrun{
ae_workload()
}
\dontrun{
art <- as.article("Submissions/2020-114")
get_AE(art)
}
}
