% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignments.R
\name{summarise_articles}
\alias{summarise_articles}
\alias{get_assignments}
\alias{get_unassigned}
\alias{find_articles}
\alias{get_latest}
\title{Summarise editors current in-tray}
\usage{
summarise_articles(editor = NULL, rejected = FALSE, other = FALSE)

get_assignments(editor, folder = "Submissions")

get_unassigned()

find_articles(editor, folder, role)

get_latest(assignments)
}
\arguments{
\item{editor}{Editors initials. If \code{NULL}, looks for the
environment variable \code{RJ_EDITOR}.}

\item{rejected}{Default \code{FALSE}. If \code{TRUE}, show
rejected articles.}

\item{other}{Default \code{FALSE}. If \code{TRUE}, list all
articles not covered by any of the other options (typically
accepted and online)}

\item{folder}{the folder to search for assignments, one of Submissions, Rejected, Accepted, or Proofs}

\item{role}{string, take value of either "Editor" or "AE"}

\item{assignments}{an output object from \code{get_assignments()} or \code{get_unassigned()}}
}
\description{
This function summarises and prints the articles an editor currently have in hand.
It also prints out the articles that has not been assigned to any editor on the top, if any.
If assigned to an object, the unassigned articles will appear on the top of the data frame.
}
