% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{update_status}
\alias{update_status}
\title{Update the article status}
\usage{
update_status(
  article,
  status,
  comments = "",
  date = Sys.Date(),
  AE = is_AE(),
  replace = TRUE
)
}
\arguments{
\item{article}{Article id, like \code{"2014-01"}}

\item{status}{new status to add, see details section for more}

\item{comments}{Any additional comments}

\item{date}{Date of status update. If omitted defaults to today.}

\item{AE}{Logical, if \code{TRUE}, \code{"AE: "} is prefixed to the status}

\item{replace}{logical, if the last status already matches \code{status}
then the status is only updated if this flag is set to \code{TRUE}.}
}
\description{
This is a general function for updating the status field in the DESCRIPTION.
}
\details{
For AEs, status is prefixed with "AE: " and valid status includes
"AE: major revision", "AE: minor revision", "AE: accept", and "AE: reject".

For Editors, use \code{accept()}, \code{reject()}, and \code{withdraw()} to
update the status as well as draft an email to the correspondence author.

Check valid status with \code{valid_status}.
}
\examples{
\dontrun{
update_status("2020-114", status = "AE: major revision")
}
}
